<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" encoding="utf-8"/>

<xsl:template match="/MEREPORT">
	<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
		<head>
			<title>Audios</title>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
			<link rel="stylesheet" type="text/css">
				<xsl:attribute name="href">
					<xsl:value-of select="csspath"/>
				</xsl:attribute>
			</link>
		</head>
		<body>
			<div id="content">		
				<h1>Audios</h1>
				<xsl:call-template name="audios"/>
				<h1>Albums</h1>
				<xsl:call-template name="albums"/>
				<h1>Artists</h1>
				<xsl:call-template name="artists"/>
				<h1>Playlists</h1>
				<xsl:call-template name="playlists"/>
				<h1>Genres</h1>
				<xsl:call-template name="genres"/>
			</div>
		</body>
	</html>
</xsl:template>

<xsl:template name="audios">
	<table>
		<tr>
			<th>id</th>
			<th>displayName</th>
			<th>mimeType</th>
			<th>title</th>
			<th>album</th>
			<th>albumId</th>
			<th>artist</th>
			<th>artistId</th>
			<th>composer</th>
			<th>duration</th>
			<th>isMusic</th>
			<th>isAlarm</th>
			<th>isNotification</th>
			<th>isRingtone</th>
			<th>track</th>
			<th>year</th>
			<th>localpath</th>
		</tr>
		
		<xsl:for-each select="audio">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="@id"/></td>
				<td><xsl:value-of select="@displayName"/></td>
				<td><xsl:value-of select="@mimeType"/></td>
				<td><xsl:value-of select="@title"/></td>
				<td><xsl:value-of select="@album"/></td>
				<td><xsl:value-of select="@albumId"/></td>
				<td><xsl:value-of select="@artist"/></td>
				<td><xsl:value-of select="@artistId"/></td>
				<td><xsl:value-of select="@composer"/></td>
				<td><xsl:value-of select="@duration"/></td>
				<td><xsl:value-of select="@isMusic"/></td>
				<td><xsl:value-of select="@isAlarm"/></td>
				<td><xsl:value-of select="@isNotification"/></td>
				<td><xsl:value-of select="@isRingtone"/></td>
				<td><xsl:value-of select="@track"/></td>
				<td><xsl:value-of select="@year"/></td>
				<td><xsl:value-of select="localpath"/></td>
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

<xsl:template name="albums">
	<table>
		<tr>
			<th>id</th>
			<th>album</th>
			<th>firstYear</th>
			<th>lastYear</th>
			<th>numberOfSongs</th>
			<th>albumArtLocalpath</th>
			<th>artist</th>
		</tr>
		
		<xsl:for-each select="album">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="@id"/></td>
				<td><xsl:value-of select="@album"/></td>
				<td><xsl:value-of select="@firstYear"/></td>
				<td><xsl:value-of select="@lastYear"/></td>
				<td><xsl:value-of select="@numberOfSongs"/></td>
				<td><xsl:value-of select="albumArtLocalpath"/></td>
				<td><xsl:value-of select="artist"/></td>
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

<xsl:template name="artists">
	<table>
		<tr>
			<th>id</th>
			<th>artist</th>
			<th>numberOfAlbums</th>
			<th>numberOfTracks</th>
		</tr>
		
		<xsl:for-each select="artist">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="@id"/></td>
				<td><xsl:value-of select="@artist"/></td>
				<td><xsl:value-of select="@numberOfAlbums"/></td>
				<td><xsl:value-of select="@numberOfTracks"/></td>
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

<xsl:template name="playlists">
	<table>
		<tr>
			<th>id</th>
			<th>name</th>
			<th>song</th>
		</tr>
		
		<xsl:for-each select="playlist">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="@id"/></td>
				<td><xsl:value-of select="@name"/></td>
				<td>
					<xsl:if test="count( song ) > 0">
						<xsl:call-template name="playlist-songs"/>
					</xsl:if>
				</td>				
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

<xsl:template name="genres">
	<table>
		<tr>
			<th>id</th>
			<th>name</th>
			<th>song</th>
		</tr>
		
		<xsl:for-each select="genre">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="@id"/></td>
				<td><xsl:value-of select="@name"/></td>
				<td>
					<xsl:if test="count( song ) > 0">
						<xsl:call-template name="genre-songs"/>
					</xsl:if>
				</td>
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

<xsl:template name="playlist-songs">
	<table>
		<tr>
			<th>id</th>
			<th>audioId</th>
			<th>audioTitle</th>
			<th>order</th>
		</tr>
		
		<xsl:for-each select="song">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="@id"/></td>
				<td><xsl:value-of select="@audioId"/></td>
				<td><xsl:value-of select="@audioTitle"/></td>
				<td><xsl:value-of select="@order"/></td>
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

<xsl:template name="genre-songs">
	<table>
		<tr>
			<th>audioId</th>
			<th>audioTitle</th>
		</tr>
		
		<xsl:for-each select="song">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="@audioId"/></td>
				<td><xsl:value-of select="@audioTitle"/></td>
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

</xsl:stylesheet>

